local assets=
{
	Asset("ANIM", "anim/shot1270.zip"),
	Asset("ATLAS", "images/inventoryimages/shot1270.xml"),
    Asset("IMAGE", "images/inventoryimages/shot1270.tex"),
}

local prefabs =
{

}

local function OnHit(inst, owner, target)
    inst:Remove()    
end


local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("shot1270")
    inst.AnimState:SetBuild("shot1270")
    inst.AnimState:PlayAnimation("idle", false)

		
    inst:AddTag("projectile")
	
				
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = 40
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(100)
	inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
	
    inst:AddComponent("inspectable")
    	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/shot1270.xml"

	return inst
end



STRINGS.NAMES.SHOT1270 = "12x70 buckshot."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SHOT1270 = "Shotgun ammo."


return Prefab( "common/inventory/shot1270", fncommon, assets)
